﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<ItineraryDetailsViewModel>" %>

<hr />
<div id="itinerary" class="panel">
    <h2>My Itinerary</h2>
    <div class="items">
    <% if (Model.ActivitiesCount == 0) %>
    <% { %>
        <p>Your itinerary is currently empty.</p>
        <p>Perform a search and then select activities to build an itinerary...</p>
    <% } else { %>
        <ul class="activities">
        <% var i = 0; %>
        <% foreach(var item in Model.Activities) %>
        <% { %>
            <li>
                <h3><%:item.Entity.Name%></h3>
                <p>
                    <%:item.Entity.Street%><br />
                    <%:item.Entity.City%>, <%:item.Entity.State%> <%:item.Entity.Zip%> | Phone: <%:item.Entity.PhoneNumber%><br />
                    <%=Html.ActionLink<ItinerariesController>(c => c.DeleteActivity(item.Entity.Id), "Remove", new { @class = "btn remove" })%>
                    <% if(i > 0) { %>
                        |
                        <a href="<%=Html.AttributeEncode(item.MoveUpInItineraryLink)%>" class="btn moveUp">Move Up</a>
                    <% } %>
                    <% if(i < Model.ActivitiesCount - 1) { %>
                        |
                        <a href="<%=Html.AttributeEncode(item.MoveDownInItineraryLink)%>" class="btn moveDown">Move Down</a>
                    <% } %>
                </p>
            </li>
            <% i++; %>
        <% } %>
        </ul>
    <% } %>
    </div>
        
    <% if (Model.ActivitiesCount > 0) { %>
    <div class="pager">
        Itinerary options:
        <%= Html.ActionLink<ItinerariesController>(c => c.Save(), "Save", new { @class = "save", id = "saveItineraryLink" }) %>
    </div>
    <% } %>
</div>